<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Hook;

use ReactionCode\RCPGTagManager\PSModule\Hook\ActionAuthentication\ActionAuthenticationPS16;
use ReactionCode\RCPGTagManager\PSModule\Hook\ActionCustomerAccountAdd\ActionCustomerAccountAddPS16;
use ReactionCode\RCPGTagManager\PSModule\Hook\ActionValidateOrder\ActionValidateOrderPS16;
use ReactionCode\RCPGTagManager\PSModule\Hook\AdminOrderView\DisplayAdminOrderContentOrder\DisplayAdminOrderContentOrderPS16;
use ReactionCode\RCPGTagManager\PSModule\Hook\AdminOrderView\DisplayAdminOrderTabOrder\DisplayAdminOrderTabOrderPS16;
use ReactionCode\RCPGTagManager\PSModule\Hook\DisplayBackOfficeHeader\DisplayBackOfficeHeaderPS16;
use ReactionCode\RCPGTagManager\PSModule\Hook\DisplayBeforeBodyClosingTag\DisplayBeforeBodyClosingTagPS16;
use ReactionCode\RCPGTagManager\PSModule\Hook\DisplayOrderConfirmation\DisplayOrderConfirmationPS16;
use ReactionCode\RCPGTagManager\PSModule\Hook\DisplayPaymentReturn\DisplayPaymentReturnPS16;
use ReactionCode\RCPGTagManager\PSModule\Hook\Header\HeaderPS16;
use ReactionCode\RCPGTagManager\PSModule\Hook\ActionOrderStatusUpdate\ActionOrderStatusUpdatePS16;

class HookFactoryPS16 extends AbstractHookFactory
{
    const HOOK_LIST = [
        'header',
        'displayPaymentReturn',
        'displayOrderConfirmation',
        'displayFooter',
        'displayBeforeBodyClosingTag',
        'displayBackOfficeHeader',
        'displayAdminOrderTabOrder',
        'displayAdminOrderContentOrder',
        'actionValidateOrder',
        'actionOrderStatusUpdate',
        'actionCustomerAccountAdd',
        'actionAuthentication'
    ];

    /**
     * @return HookInterface
     */
    public function createHeader()
    {
        return new HeaderPS16($this->module);
    }

    /**
     * @return HookInterface
     */
    public function createDisplayPaymentReturn()
    {
        return new DisplayPaymentReturnPS16($this->module);
    }

    /**
     * @return HookInterface
     */
    public function createDisplayOrderConfirmation()
    {
        return new DisplayOrderConfirmationPS16($this->module);
    }

    /**
     * @return HookInterface
     */
    public function createDisplayFooter()
    {
        return $this->createDisplayBeforeBodyClosingTag();
    }

    /**
     * @return HookInterface
     */
    public function createDisplayBeforeBodyClosingTag()
    {
        return new DisplayBeforeBodyClosingTagPS16($this->module);
    }

    /**
     * @return HookInterface
     */
    public function createDisplayBackOfficeHeader()
    {
        return new DisplayBackOfficeHeaderPS16($this->module);
    }

    /**
     * @return HookInterface
     */
    public function createDisplayAdminOrderTabOrder()
    {
        return new DisplayAdminOrderTabOrderPS16($this->module);
    }

    /**
     * @return HookInterface
     */
    public function createDisplayAdminOrderContentOrder()
    {
        return new DisplayAdminOrderContentOrderPS16($this->module);
    }


    /**
     * @return HookInterface
     */
    public function createActionValidateOrder()
    {
        return new ActionValidateOrderPS16($this->module);
    }

    /**
     * @return HookInterface
     */
    public function createActionOrderStatusUpdate()
    {
        return new ActionOrderStatusUpdatePS16($this->module);
    }

    /**
     * @return HookInterface
     */
    public function createActionCustomerAccountAdd()
    {
        return new ActionCustomerAccountAddPS16($this->module);
    }

    /**
     * @return HookInterface
     */
    public function createActionAuthentication()
    {
        return new ActionAuthenticationPS16($this->module);
    }
}
