<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Hook\Header;

class HeaderPS17 extends AbstractHeader
{

    /**
     * @param array $params
     * @return false|string
     */
    public function exec(array $params = [])
    {
        if (empty($this->configuration['gtm']['tracking_id'])) {
            return false;
        }

        $this->context->smarty->assign([
            'tracking_configuration' => $this->encodeData($this->configuration),
            'header_js' => $this->getTrackingClientJS()
        ]);

        return $this->module->fetch(
            'module:'.
            $this->module->name.
            '/views/templates/hook/header.tpl'
        );
    }
}
