<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Hook\Header;

use ReactionCode\RCPGTagManager\PSModule\Hook\AbstractHook;
use ReactionCode\RCPGTagManager\PSModule\RCTrackingModuleInterface;

abstract class AbstractHeader extends AbstractHook
{
    /**
     * @var array
     */
    protected $configuration;

    public function __construct(RCTrackingModuleInterface $module)
    {
        parent::__construct($module);
        $this->configuration = $this->getConfiguration();
    }

    /**
     * @return array
     */
    private function getConfiguration(): array
    {
        $configurator_service = $this->module->getServiceProvider()->getConfiguratorService();
        return [
            'gtm' => $configurator_service->getGTMConfiguration(),
            'gua' => $configurator_service->getGUAConfiguration(),
            'ga4' => $configurator_service->getGA4Configuration(),
            'gads' => $configurator_service->getGAdsConfiguration(),
            'gfeeds' => $configurator_service->getGFeedsConfiguration(),
            'optimize' => $configurator_service->getOptimizeConfiguration(),
            'bing' => $configurator_service->getBingConfiguration(),
            'facebook' => $configurator_service->getFacebookConfiguration(),
            'twitter' => $configurator_service->getTwitterConfiguration(),
            'criteo' => $configurator_service->getCriteoConfiguration(),
            'context' => $configurator_service->getContextConfiguration()
        ];
    }

    protected function getTrackingClientJS(): string
    {
        return $this->module->getPathUri() . 'views/js/hook/trackingClient.bundle.js';
    }
}
