<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Hook\DisplayBeforeBodyClosingTag;

use Order;
use PrestaShopDatabaseException;
use PrestaShopException;
use ReactionCode\RCPGTagManager\PSModule\OrderHandler\Fetcher\OrderFetcherPS17;
use Tools;

class DisplayBeforeBodyClosingTagPS17 extends AbstractDisplayBeforeBodyClosingTag
{
    /**
     * @throws PrestaShopException
     * @throws PrestaShopDatabaseException
     */
    public function exec(array $params = [])
    {
        parent::exec($params);

        $this->context->smarty->assign(['trackingData' => $this->encodeData($this->tracking_data)]);

        return $this->module->fetch(
            'module:' .
            $this->module->name .
            '/views/templates/hook/footer.tpl'
        );
    }

    /**
     * @return Order|null
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    protected function fetchOrder(): ?Order
    {
        return (new OrderFetcherPS17($this->module))->fetchOrder();
    }

    /**
     * @return bool
     */
    protected function isCart(): bool
    {
        return Tools::getValue('fc') === false && Tools::getValue('controller') === 'cart';
    }

    /**
     * @return bool
     */
    protected function isCheckout(): bool
    {
        $module_detector_service = $this->module->getServiceProvider()->getModuleDetectorService();
        $checkout_module = $module_detector_service->getCheckoutModule();

        return Tools::getValue('controller') === $checkout_module['controller'];
    }

    /**
     * @return array
     */
    protected function getTemplateProduct(): array
    {
        $result = [];
        $template_product = $this->context->smarty->getTemplateVars('product');
        if ($template_product) {
            $result[] = $template_product;
        }
        return $result;
    }

    /**
     * @return array
     */
    protected function getTemplateProductList(): array
    {
        $result = [];
        $accessories = $this->context->smarty->getTemplateVars('accessories');
        $listing = $this->context->smarty->getTemplateVars('listing');

        if (!empty($accessories)) {
            $result = array_merge($result, $accessories);
        }

        if (!empty($listing['products'])) {
            $result = array_merge($result, $listing['products']);
        }

        return $result;
    }
}
