<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Hook\DisplayBeforeBodyClosingTag;

use Order;
use OrderController;
use PrestaShopDatabaseException;
use PrestaShopException;
use ReactionCode\RCPGTagManager\PSModule\OrderHandler\Fetcher\OrderFetcherPS16;
use Tools;

class DisplayBeforeBodyClosingTagPS16 extends AbstractDisplayBeforeBodyClosingTag
{
    public function exec(array $params = [])
    {
        parent::exec($params);

        $this->context->smarty->assign(['trackingData' => $this->encodeData($this->tracking_data)]);

        return $this->module->display($this->module->name, 'views/templates/hook/footer.tpl');
    }

    /**
     * @return Order|null
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    protected function fetchOrder(): ?Order
    {
        return (new OrderFetcherPS16($this->module))->fetchOrder();
    }

    protected function isCart(): bool
    {
        $controller_name = Tools::getValue('controller');
        return $controller_name === 'order' &&
            $this->context->controller instanceof OrderController &&
            $this->context->controller->step === 0
        ;
    }

    protected function getTemplateProduct(): array
    {
        $result = [];
        $template_product = $this->context->smarty->getTemplateVars('product');
        if ($template_product) {
            $result[] = $template_product;
        }
        return $result;
    }

    protected function getTemplateProductList(): array
    {
        $result = [];
        $accessories = $this->context->smarty->getTemplateVars('accessories');
        $listing = $this->context->smarty->getTemplateVars('products');

        if (!empty($accessories)) {
            $result = array_merge($result, $accessories);
        }

        if (!empty($listing)) {
            $result = array_merge($result, $listing);
        }

        return $result;
    }
}
