<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Hook\AdminOrderView\DisplayAdminOrderTabOrder;

use ReactionCode\RCPGTagManager\PSModule\Hook\AdminOrderView\AbstractAdminOrderView;

abstract class AbstractDisplayAdminOrderTabOrder extends AbstractAdminOrderView
{
    /**
     * @param array $params
     * @return false|string
     */
    public function exec(array $params = [])
    {
        $this->setTemplateData();
        return $this->render();
    }

    protected function setTemplateData()
    {
        $this->template_data = [
            'tracking_status_tab_link' => [
                'icon' => $this->module->getPathUri() . 'views/img/admin/tracking_status_tab_link_icon.svg',
            ]
        ];
    }

    /**
     * @return false|string
     */
    protected function render()
    {
        $this->context->smarty->assign(['rcpgtm_template_data' => $this->template_data]);

        $this->context->controller->addCSS(
            $this->module->getPathUri() .
            'views/css/admin/controllers/order/tracking_status_tab_link.css'
        );

        return $this->module->display(
            $this->module->getPathUri(),
            'views/templates/admin/controllers/order/tracking_status_tab_link.tpl'
        );
    }
}
