<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Hook\AdminOrderView\DisplayAdminOrderTabLink;

use Exception;

class DisplayAdminOrderTabLinkPS17 extends AbstractDisplayAdminOrderTabLink
{
    /**
     * @param array $params
     * @return mixed|string
     * @throws Exception
     */
    public function exec(array $params = [])
    {
        $render = '';
        if ($this->isSymfonyView()) {
            $this->setTemplateData();
            $render = $this->render();
        }
        return $render;
    }

    protected function setTemplateData()
    {
        $this->template_data = [
            'tracking_status_tab_link' => [
                'icon' => $this->module->getPathUri() . 'views/img/admin/tracking_status_tab_link_icon.svg',
            ]
        ];
    }

    /**
     * @return mixed
     * @throws Exception
     */
    protected function render()
    {
        return $this->module->get('twig')->render(
            '@Modules/' .
            $this->module->name .
            '/views/PrestaShop/Admin/Sell/Order/Order/tracking_status_tab_link.html.twig',
            ['rcpgtm_template_data' => $this->template_data]
        );
    }
}
