<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Hook\AdminOrderView\DisplayAdminOrderTabContent;

use Exception;
use Order;
use PrestaShopDatabaseException;
use PrestaShopException;
use RCPGTagManagerOrderTrackingStatus;

class DisplayAdminOrderTabContentPS17 extends AbstractDisplayAdminOrderTabContent
{
    /**
     * @param array $params
     * @return mixed|string
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     * @throws Exception
     */
    public function exec(array $params = [])
    {
        $render = '';
        if ($this->isSymfonyView()) {
            $this->setTemplateData($params);
            $render = $this->render();
        }
        return $render;
    }

    /**
     * @throws PrestaShopException
     * @throws PrestaShopDatabaseException
     */
    protected function setTemplateData(array $params = [])
    {
        $order = new Order($params['id_order']);
        $order_tracking_status = new RCPGTagManagerOrderTrackingStatus((int)$params['id_order']);

        $this->template_data = [
            'tracking_status_tab_content' => [
                'order' => $order,
                'order_status' => $order_tracking_status,
                'status_data' => $this->getStatusData($order_tracking_status)
            ]
        ];
    }

    /**
     * @return mixed
     * @throws Exception
     */
    protected function render()
    {
        return $this->module->get('twig')->render(
            '@Modules/' .
            $this->module->name .
            '/views/PrestaShop/Admin/Sell/Order/Order/tracking_status_tab_content.html.twig',
            ['rcpgtm_template_data' => $this->template_data]
        );
    }
}
