<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Hook\AdminOrderView\DisplayAdminOrderContentOrder;

use PrestaShopDatabaseException;
use PrestaShopException;
use RCPGTagManagerOrderTrackingStatus;
use ReactionCode\RCPGTagManager\PSModule\Hook\AdminOrderView\AbstractAdminOrderView;

abstract class AbstractDisplayAdminOrderContentOrder extends AbstractAdminOrderView
{
    /**
     * @param array $params
     * @return false|string
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function exec(array $params = [])
    {
        $this->setTemplateData($params);
        return $this->render();
    }

    /**
     * @param array $params
     * @return void
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    protected function setTemplateData(array $params = [])
    {
        $order_tracking_status = new RCPGTagManagerOrderTrackingStatus((int)$params['order']->id);

        $this->template_data = [
            'tracking_status_tab_content' => [
                'order' => $params['order'],
                'order_status' => $order_tracking_status,
                'status_data' => $this->getStatusData($order_tracking_status)
            ]
        ];
    }

    /**
     * @return false|string
     */
    protected function render()
    {
        $this->context->smarty->assign(['rcpgtm_template_data' => $this->template_data]);

        $this->context->controller->addCSS(
            $this->module->getPathUri() .
            'views/css/admin/controllers/order/tracking_status_tab_content.css'
        );

        $this->context->controller->addJS(
            $this->module->getPathUri() .
            'views/js/admin/controllers/order/adminOrderTrackingStatus.bundle.js'
        );

        return $this->module->display(
            $this->module->getPathUri(),
            'views/templates/admin/controllers/order/tracking_status_tab_content.tpl'
        );
    }
}
