<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Hook\AdminOrderView;

use RCPGTagManagerOrderTrackingStatus;
use ReactionCode\RCPGTagManager\PSModule\Hook\AbstractHook;

abstract class AbstractAdminOrderView extends AbstractHook
{
    /**
     * @var array
     */
    protected $template_data = [];

    /**
     * @return bool
     */
    protected function isSymfonyView(): bool
    {
        return method_exists($this->module, 'isSymfonyContext') && $this->module->isSymfonyContext();
    }

    protected function getStatusData(RCPGTagManagerOrderTrackingStatus $order_status): array
    {
        $message_cases = $this->getOrderStatusMessageCases();
        $current_case = $order_status->status ?: RCPGTagManagerOrderTrackingStatus::NOT_IN_CONTROL_TABLE;
        return $message_cases[$current_case];
    }

    /**
     * @return array[]
     */
    private function getOrderStatusMessageCases(): array
    {
        return [
            RCPGTagManagerOrderTrackingStatus::NOT_IN_CONTROL_TABLE => [
                'is_sent' => false,
                'level' => 3,
                'messages' => [
                    $this->module->l('order not found in control table'),
                    $this->module->l('if control table was truncated') .
                        ', ' .
                        $this->module->l('reinstall the module') .
                        ', ' .
                        $this->module->l('otherwise the order has been placed out of standard channels')
                ]
            ],
            RCPGTagManagerOrderTrackingStatus::SETUP => [
                'is_sent' => false,
                'level' => 2,
                'messages' => [
                    $this->module->l('order set in control table at installation process'),
                    $this->module->l('this order is not eligible for tracking to avoid report issues')
                ]
            ],
            RCPGTagManagerOrderTrackingStatus::WAITING_THANK_YOU_PAGE => [
                'is_sent' => false,
                'level' => 3,
                'messages' => [
                    $this->module->l('waiting customer to reach the order confirmation page'),
                    $this->module->l('if some issue occurs with the conversion') .
                        ', ' .
                        $this->module->l('it will be required to configure a cron job'),
                    $this->module->l('check the guide for more details')
                ]
            ],
            RCPGTagManagerOrderTrackingStatus::CUSTOMER_BROWSER => [
                'is_sent' => true,
                'level' => 1,
                'messages' => [
                    $this->module->l('order properly send by customer device')
                ]
            ],
            RCPGTagManagerOrderTrackingStatus::SERVER_AD_BLOCK => [
                'is_sent' => true,
                'level' => 1,
                'messages' => [
                    $this->module->l('order aborted by adblock and send by API')
                ]
            ],
            RCPGTagManagerOrderTrackingStatus::SERVER_ADMIN => [
                'is_sent' => true,
                'level' => 1,
                'messages' => [
                    $this->module->l('order created by backoffice and send by API')
                ]
            ],
            RCPGTagManagerOrderTrackingStatus::SERVER_WEBSERVICE => [
                'is_sent' => true,
                'level' => 1,
                'messages' => [
                    $this->module->l('order created by webservice and send by API')
                ]
            ],
            RCPGTagManagerOrderTrackingStatus::SERVER_CRON => [
                'is_sent' => true,
                'level' => 3,
                'messages' => [
                    $this->module->l('order send by API on cron job'),
                    $this->module->l('if many orders has been send by CRON'),
                    $this->module->l('means that something is wrong in payment module'),
                    $this->module->l('check the guide for more details')
                ]
            ],
            RCPGTagManagerOrderTrackingStatus::SERVER_VALID_STATUS => [
                'is_sent' => true,
                'level' => 2,
                'messages' => [
                    $this->module->l('order send by API after update order to a valid status')
                ]
            ],
            RCPGTagManagerOrderTrackingStatus::ABORTED_INVALID_STATUS => [
                'is_sent' => false,
                'level' => 3,
                'messages' => [
                    $this->module->l('order not send cause does not match a valid status')
                ]
            ]
        ];
    }
}
