<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Hook\ActionValidateOrder;

use Cart;
use Currency;
use Customer;
use Order;
use OrderState;
use PrestaShopDatabaseException;
use PrestaShopException;
use RCPGTagManagerOrderTrackingStatus;
use ReactionCode\RCPGTagManager\PSModule\Hook\AbstractHook;
use ReactionCode\RCPGTagManager\PSModule\OrderHandler\Validator\AbstractOrderValidator;

abstract class AbstractActionValidateOrder extends AbstractHook
{
    /**
     * @var AbstractOrderValidator
     */
    protected $order_validator;

    /**
     * @var array
     */
    protected $params = [];

    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function exec(array $params = [])
    {
        $this->params = $params;

        if ($this->isValidRequest()) {
            $this->params['order']->current_state = $this->params['orderStatus']->id;
            if ($this->order_validator->isValidOrderComplete($this->params['order'])) {
                if ($this->order_validator->isWebOrder()) {
                    $order_tracking_status = RCPGTagManagerOrderTrackingStatus::WAITING_THANK_YOU_PAGE;
                } else {
                    $order_tracking_status = $this->order_validator->isAdminOrder() ?
                        RCPGTagManagerOrderTrackingStatus::SERVER_ADMIN :
                        RCPGTagManagerOrderTrackingStatus::SERVER_WEBSERVICE
                    ;
                    $this->sendServerOrder();
                }
            } else {
                $order_tracking_status = RCPGTagManagerOrderTrackingStatus::ABORTED_INVALID_STATUS;
            }
            RCPGTagManagerOrderTrackingStatus::setOrderStatus(
                $this->params['order'],
                $order_tracking_status
            );
        }
    }

    /**
     * @return bool
     */
    private function isValidRequest(): bool
    {
        return is_array($this->params) &&
            isset(
                $this->params['cart'],
                $this->params['order'],
                $this->params['customer'],
                $this->params['currency'],
                $this->params['orderStatus']
            ) &&
            $this->params['cart'] instanceof Cart &&
            $this->params['order'] instanceof Order &&
            $this->params['customer'] instanceof Customer &&
            $this->params['currency'] instanceof Currency &&
            $this->params['orderStatus'] instanceof OrderState
        ;
    }

    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    private function sendServerOrder()
    {
        $api_handler = $this->module->getServiceProvider()->getAPIService();
        $api_handler->sendOrderComplete($this->params['order']);
    }
}
