<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Hook\ActionOrderStatusUpdate;

use Order;
use OrderState;
use PrestaShopDatabaseException;
use PrestaShopException;
use RCPGTagManagerOrderTrackingStatus;
use ReactionCode\RCPGTagManager\PSModule\Hook\AbstractHook;
use ReactionCode\RCPGTagManager\PSModule\OrderHandler\Validator\AbstractOrderValidator;

abstract class AbstractActionOrderStatusUpdate extends AbstractHook
{
    /**
     * @var AbstractOrderValidator
     */
    protected $order_validator;

    /**
     * @var array
     */
    protected $params = [];

    /**
     * @param array $params
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function exec(array $params = [])
    {
        $this->params = $params;

        if ($this->isValidRequest()) {
            if ($this->order_validator->isAdminOrder() || $this->order_validator->isWebServiceOrder()) {
                $order = $this->getOrder();
                $api_handler = $this->module->getServiceProvider()->getAPIService();
                if (RCPGTagManagerOrderTrackingStatus::isPendingTransaction($order)) {
                    if ($this->order_validator->isValidOrderComplete($order)) {
                        $api_handler->sendOrderComplete($order);
                        RCPGTagManagerOrderTrackingStatus::setOrderStatus(
                            $order,
                            RCPGTagManagerOrderTrackingStatus::SERVER_VALID_STATUS
                        );
                    }
                } else {
                    if ($this->order_validator->isValidOrderRefund($order)) {
                        $api_handler->sendOrderRefund($order);
                    }
                }
            }
        }
    }

    /**
     * @return bool
     */
    protected function isValidRequest(): bool
    {
        return is_array($this->params) &&
            isset(
                $this->params['id_order'],
                $this->params['newOrderStatus']
            ) &&
            !empty($this->params['id_order']) &&
            $this->params['newOrderStatus'] instanceof OrderState
        ;
    }

    /**
     * @return Order
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    protected function getOrder(): Order
    {
        $order = new Order($this->params['id_order']);
        $order->current_state = $this->params['newOrderStatus']->id;
        return $order;
    }
}
