<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Hook;

use Module;
use ReactionCode\RCPGTagManager\PSModule\Hook\Disabled\Disabled;
use ReactionCode\RCPGTagManager\PSModule\RCTrackingModuleInterface;

abstract class AbstractHookFactory implements HookFactoryInterface
{
    /**
     * @var Module & RCTrackingModuleInterface
     */
    protected $module;

    public function __construct(RCTrackingModuleInterface $module)
    {
        $this->module = $module;
    }

    /**
     * @return HookInterface
     */
    public function getHook(string $hook): HookInterface
    {
        $create_method_name = self::getCreateMethodName($hook);
        return method_exists($this, $create_method_name) ?
            $this->{$create_method_name}() :
            $this->createDisabled()
            ;
    }

    /**
     * @return string
     */
    private static function getCreateMethodName(string $hook): string
    {
        return str_replace('hook', 'create', $hook);
    }

    /**
     * @return Disabled
     */
    protected function createDisabled(): Disabled
    {
        return new Disabled($this->module);
    }
}
