<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Hook;

use Context;
use Module;
use ReactionCode\RCPGTagManager\PSModule\RCTrackingModuleInterface;

abstract class AbstractHook implements HookInterface
{
    /**
     * @var Module & RCTrackingModuleInterface
     */
    protected $module;

    /**
     * @var Context
     */
    protected $context;

    /**
     * @param RCTrackingModuleInterface $module
     */
    public function __construct(RCTrackingModuleInterface $module)
    {
        $this->module = $module;
        $this->context = Context::getContext();
    }

    /**
     * @param array $data
     * @return string
     */
    protected function encodeData(array $data): string
    {
        return rawurlencode(json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
    }
}
