<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form\Transformer;

class DomainListToStringTransformer implements DataTransformerInterface
{
    /**
     * @inheritDoc
     */
    public function transform($value)
    {
        return is_array($value) ? implode(PHP_EOL, $value) : $value;
    }

    /**
     * @inheritDoc
     */
    public function reverseTransform($value)
    {
        $domains = preg_split('/\r\n|\r|\n/', $value);

        $filtered_domains = array_filter($domains);

        return array_map([$this,'normalizeString'], $filtered_domains);
    }


    /**
     * @param string $string
     * @return string
     */
    private function normalizeString(string $string): string
    {
        return trim(mb_strtolower($string));
    }
}
