<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form\Section;

use ReactionCode\RCPGTagManager\PSModule\Form\Validator\PregMatchValidator;

class FormTwitter extends AbstractFormSection
{
    const FORM_ID = 'twitter';

    /**
     * @return string[]
     */
    public function getTab(): array
    {
        return [
            'id' => self::FORM_ID,
            'group' => 'form',
            'name' => 'Twitter'
        ];
    }

    /**
     * @return array[]
     */
    public function getInputs(): array
    {
        return [
            [
                'type' => 'text',
                'label' => 'Twitter ID',
                'name' => self::FORM_ID.'_tracking_id',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('The format is') . ': XXXXXXXXXX',
                'validate' => new PregMatchValidator('/^[A-Z0-9]{4,10}$/i')
            ]
        ];
    }
}
