<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form\Section;

class FormSupportLinkTab extends AbstractFormSection
{
    private const ADDONS_SUPPORT_URL = 'https://addons.prestashop.com/contact-form.php?id_product=27146';

    /**
     * @return array
     */
    public function getTab(): array
    {
        return [
            'id' => 'support',
            'group' => 'link',
            'icon' => 'support',
            'name' => $this->module->l('Support'),
            'link' => self::ADDONS_SUPPORT_URL,
            'target' => '_blank'
        ];
    }

    /**
     * @return array
     */
    public function getForm(): array
    {
        return [];
    }

    /**
     * @return array
     */
    public function getInputs(): array
    {
        return [];
    }
}
