<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form\Section;

interface FormSectionInterface
{
    /**
     * @return array
     */
    public function getTab(): array;

    /**
     * @return array
     */
    public function getForm(): array;

    /**
     * @return array
     */
    public function getContent(): array;

    /**
     * @return array
     */
    public function getInputs(): array;


    /**
     * @return array
     */
    public function getFormValues(): array;

    /**
     * @return array
     */
    public function getModelValues(): array;

    /**
     * @return array
     */
    public function getErrors(): array;

    /**
     * @return bool
     */
    public function isValid(): bool;

    public function setValues();

    public function setDefaultValues();
}
