<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form\Section;

class FormRateLinkTab extends AbstractFormSection
{
    private const ADDONS_RATING_URL = 'https://addons.prestashop.com/ratings.php';

    /**
     * @return array
     */
    public function getTab(): array
    {
        return [
            'id' => 'rate',
            'group' => 'link',
            'icon' => 'star',
            'name' => $this->module->l('Request Improvements'),
            'link' => self::ADDONS_RATING_URL,
            'target' => '_blank'
        ];
    }

    /**
     * @return array
     */
    public function getForm(): array
    {
        return [];
    }

    /**
     * @return array
     */
    public function getInputs(): array
    {
        return [];
    }
}
