<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form\Section;

use ReactionCode\RCPGTagManager\PSModule\Form\Validator\PregMatchValidator;

class FormOptimize extends AbstractFormSection
{
    const FORM_ID = 'optimize';

    /**
     * @return string[]
     */
    public function getTab(): array
    {
        return [
            'id' => self::FORM_ID,
            'group' => 'form',
            'name' => 'Google Optimize'
        ];
    }

    /**
     * @return array[]
     */
    public function getInputs(): array
    {
        return [
            [
                'type' => 'text',
                'label' => 'Google Optimize ID',
                'name' => self::FORM_ID.'_tracking_id',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('The format is') .
                    ': GTM-XXXXXXX ' .
                    $this->module->l('or') .
                    ' OPT-XXXXXXX',
                'validate' => new PregMatchValidator('/^(GTM|OPT)-[A-Z0-9]{4,10}$/i')
            ],
            [
                'type' => 'switch',
                'label' => $this->module->l('asynchronous mode'),
                'name' => self::FORM_ID.'_is_async',
                'desc' => $this->module->l('load the script asynchronously'),
                'hint' => $this->module->l('check the guide to know what is better'),
                'values' => [
                    [
                        'id' => 'active_on',
                        'value' => true
                    ],
                    [
                        'id' => 'active_off',
                        'value' => false
                    ]
                ]
            ],
            [
                'type' => 'text',
                'label' => $this->module->l('Hiding Class'),
                'name' => self::FORM_ID.'_hiding_class_name',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('CSS class name'),
                'hint' => $this->module->l('An empty value disables the page hiding snippet'),
                'default_value' => 'optimize-loading'
            ],
            [
                'type' => 'select',
                'label' => $this->module->l('Hiding Timeout'),
                'name' => self::FORM_ID.'_hiding_timeout',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('Hiding timeout (milliseconds)'),
                'options' => [
                    'query' => $this->getHidingTimeOptions(),
                    'id' => 'id',
                    'name' => 'name'
                ],
                'default_value' => 3000
            ]
        ];
    }

    /**
     * @return array[]
     */
    private function getHidingTimeOptions(): array
    {
        $hiding_time = [
            [
                'id' => 0,
                'name' => 'disabled'
            ]
        ];

        foreach (range(1, 5) as $step) {
            $hiding_time_value = 1000 + $step * 1000;
            $hiding_time[] = [
                'id' => $hiding_time_value,
                'name' => $hiding_time_value
            ];
        }
        return $hiding_time;
    }
}
