<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form\Section;

class FormGuideLinkTab extends AbstractFormSection
{
    private const BASE_URL = 'https://docs.reactioncode.com';

    /**
     * @return array
     */
    public function getTab(): array
    {
        $doc_module_url = self::BASE_URL.'/premium-google-tag-manager/getting-started/';

        return [
            'id' => 'documentation',
            'group' => 'link',
            'icon' => 'book',
            'name' => $this->module->l('Documentation'),
            'link' => $doc_module_url,
            'target' => '_blank'
        ];
    }

    /**
     * @return array
     */
    public function getForm(): array
    {
        return [];
    }

    /**
     * @return array
     */
    public function getInputs(): array
    {
        return [];
    }
}
