<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form\Section;

use ReactionCode\RCPGTagManager\PSModule\Form\Transformer\DomainListToStringTransformer;
use ReactionCode\RCPGTagManager\PSModule\Form\Validator\BetweenIntValidator;
use ReactionCode\RCPGTagManager\PSModule\Form\Validator\PregMatchValidator;

class FormGUA extends AbstractFormSection
{
    const FORM_ID = 'gua';

    /**
     * @return string[]
     */
    public function getTab(): array
    {
        return [
            'id' => self::FORM_ID,
            'group' => 'form',
            'name' => 'Google Universal Analytics'
        ];
    }

    /**
     * @return array[]
     */
    public function getInputs(): array
    {
        $dimension_indexes = $this->getDimensionIndexes();

        return [
            [
                'type' => 'text',
                'label' => 'Google Universal Analytics ID',
                'name' => self::FORM_ID.'_tracking_id',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('The format is') . ': UA-XXXX-Y',
                'validate' => new PregMatchValidator('/^UA-[0-9]{4,10}(-[0-9]{1,4})?$/i')
            ],
            [
                'type' => 'switch',
                'label' => $this->module->l('Data Import'),
                'name' => self::FORM_ID.'_is_data_import',
                'desc' => $this->module->l('Enable Data Import for products'),
                'hint' => $this->module->l('Check the guide for detailed instructions'),
                'values' => [
                    [
                        'id' => 'active_on',
                        'value' => true
                    ],
                    [
                        'id' => 'active_off',
                        'value' => false
                    ]
                ]
            ],
            [
                'type' => 'text',
                'label' => $this->module->l('Site Speed Sample Rate'),
                'name' => self::FORM_ID.'_site_speed_sample_rate',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l(
                    'Percentage of users to include in site speed data reports'
                ),
                'hint' => 'Min: 1 - Max: 100',
                'validate' => new BetweenIntValidator(1, 100),
                'default_value' => 1
            ],
            [
                'type' => 'switch',
                'label' => $this->module->l('Anonymize IP'),
                'name' => self::FORM_ID.'_is_anonymize_ip',
                'desc' => $this->module->l(
                    'Needed in some countries, to be compliant with privacy policies'
                ),
                'values' => [
                    [
                        'id' => 'active_on',
                        'value' => true
                    ],
                    [
                        'id' => 'active_off',
                        'value' => false
                    ]
                ]
            ],
            [
                'type' => 'switch',
                'label' => 'User-ID',
                'name' => self::FORM_ID.'_is_user_id',
                'desc' => $this->module->l(
                    'Unify the customer sessions when him uses different devices'
                ),
                'values' => [
                    [
                        'id' => 'active_on',
                        'value' => true
                    ],
                    [
                        'id' => 'active_off',
                        'value' => false
                    ]
                ]
            ],
            [
                'type' => 'switch',
                'label' => $this->module->l('Enhanced Link Attribution'),
                'name' => self::FORM_ID.'_is_link_attribution',
                'desc' => $this->module->l('Allows a better track links on your page'),
                'values' => [
                    [
                        'id' => 'active_on',
                        'value' => true
                    ],
                    [
                        'id' => 'active_off',
                        'value' => false
                    ]
                ]
            ],
            [
                'type' => 'select',
                'label' => $this->module->l('ecomm_prodid Index'),
                'name' => self::FORM_ID.'_dimension_ecomm_prodid',
                'class' => 'js-dimensions',
                'desc' => $this->module->l(
                    'This index must match the index of the GA custom dimension'
                ),
                'options' => [
                    'query' => $dimension_indexes,
                    'id' => 'id',
                    'name' => 'name'
                ],
                'default_value' => 1
            ],
            [
                'type' => 'select',
                'label' => $this->module->l('ecomm_pagetype Index'),
                'name' => self::FORM_ID.'_dimension_ecomm_pagetype',
                'class' => 'js-dimensions',
                'desc' => $this->module->l(
                    'This index must match the index of the GA custom dimension'
                ),
                'options' => [
                    'query' => $dimension_indexes,
                    'id' => 'id',
                    'name' => 'name'
                ],
                'default_value' => 2
            ],
            [
                'type' => 'select',
                'label' => $this->module->l('ecomm_totalvalue Index'),
                'name' => self::FORM_ID.'_dimension_ecomm_totalvalue',
                'class' => 'js-dimensions',
                'desc' => $this->module->l(
                    'This index must match the index of the GA custom dimension'
                ),
                'options' => [
                    'query' => $dimension_indexes,
                    'id' => 'id',
                    'name' => 'name'
                ],
                'default_value' => 3
            ],
            [
                'type' => 'select',
                'label' => $this->module->l('dynx_itemid Index'),
                'name' => self::FORM_ID.'_dimension_dynx_itemid',
                'class' => 'js-dimensions',
                'desc' => $this->module->l(
                    'This index must match the index of the GA custom dimension'
                ),
                'options' => [
                    'query' => $dimension_indexes,
                    'id' => 'id',
                    'name' => 'name'
                ],
                'default_value' => 4
            ],
            [
                'type' => 'select',
                'label' => $this->module->l('dynx_itemid2 Index'),
                'name' => self::FORM_ID.'_dimension_dynx_itemid2',
                'class' => 'js-dimensions',
                'desc' => $this->module->l(
                    'This index must match the index of the GA custom dimension'
                ),
                'options' => [
                    'query' => $dimension_indexes,
                    'id' => 'id',
                    'name' => 'name'
                ],
                'default_value' => 5
            ],
            [
                'type' => 'select',
                'label' => $this->module->l('dynx_pagetype Index'),
                'name' => self::FORM_ID.'_dimension_dynx_pagetype',
                'class' => 'js-dimensions',
                'desc' => $this->module->l(
                    'This index must match the index of the GA custom dimension'
                ),
                'options' => [
                    'query' => $dimension_indexes,
                    'id' => 'id',
                    'name' => 'name'
                ],
                'default_value' => 6
            ],
            [
                'type' => 'select',
                'label' => $this->module->l('dynx_totalvalue Index'),
                'name' => self::FORM_ID.'_dimension_dynx_totalvalue',
                'class' => 'js-dimensions',
                'desc' => $this->module->l(
                    'This index must match the index of the GA custom dimension'
                ),
                'options' => [
                    'query' => $dimension_indexes,
                    'id' => 'id',
                    'name' => 'name'
                ],
                'default_value' => 7
            ],
            [
                'type' => 'textarea',
                'label' => $this->module->l('Cross Domain Tracking List'),
                'name' => self::FORM_ID.'_cross_domain_list',
                'class' => 'fixed-width-xl js-textarea-list',
                'desc' => $this->module->l('Track your linked domains with the same GA ID'),
                'hint' => $this->module->l('Include one domain by line'),
                'is_array_model' => true,
                'transform' => new DomainListToStringTransformer(),
                'validate' => new PregMatchValidator(
                    '/^(?=.{3,256}$)((?:(?!-)[a-z0-9-]{2,63}(?<!-)\.){1,127}(?:(?!\.)[a-z]{2,6}(?<!\.)))$/'
                )
            ]
        ];
    }

    /**
     * @return array
     */
    protected function getDimensionIndexes(): array
    {
        $dimension_indexes = [];
        foreach (range(1, 20) as $index) {
            $dimension_indexes[] = [
                'id' => $index,
                'name' => $index
            ];
        }
        return $dimension_indexes;
    }
}
