<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form\Section;

use ReactionCode\RCPGTagManager\PSModule\Form\Validator\PregMatchValidator;

class FormGTM extends AbstractFormSection
{
    const FORM_ID = 'gtm';

    /**
     * @return array
     */
    public function getTab(): array
    {
        return [
            'id' => self::FORM_ID,
            'group' => 'form',
            'name' => 'Tag Manager',
            'active' => 1
        ];
    }

    /**
     * @return array
     */
    public function getInputs(): array
    {
        return [
            [
                'type' => 'hidden',
                'name' => self::FORM_ID.'_caveat',
                'default_value' => 1
            ],
            [
                'type' => 'switch',
                'label' => $this->module->l('Exclude Internal Traffic'),
                'name' => self::FORM_ID.'_is_exclude_internal_tracking',
                'desc' => $this->module->l('Disable GTM for your internal traffic'),
                'values' => [
                    [
                        'id' => 'active_on',
                        'value' => true
                    ],
                    [
                        'id' => 'active_off',
                        'value' => false
                    ]
                ]
            ],
            [
                'type' => 'text',
                'required' => true,
                'label' => 'Google Tag Manager ID',
                'name' => self::FORM_ID.'_tracking_id',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('The format is') . ': GTM-XXXXXXX',
                'validate' => new PregMatchValidator('/^GTM-[A-Z0-9]{4,10}$/i')
            ]
        ];
    }
}
