<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form\Section;

class FormGFeeds extends AbstractFormSection
{
    const FORM_ID = 'gfeeds';

    /**
     * @return array
     */
    public function getTab(): array
    {
        return [
            'id' => self::FORM_ID,
            'group' => 'form',
            'name' => $this->module->l('Google Data Feeds')
        ];
    }

    /**
     * @return array[]
     */
    public function getInputs(): array
    {
        return [
            [
                'type' => 'switch',
                'label' => $this->module->l('Dynamic Remarketing (Retail)'),
                'name' => self::FORM_ID.'_is_remarketing_retail',
                'desc' => $this->module->l('Remarketing with Merchant Center feed'),
                'values' => [
                    [
                        'id' => 'active_on',
                        'value' => true
                    ],
                    [
                        'id' => 'active_off',
                        'value' => false
                    ]
                ]
            ],
            [
                'type' => 'text',
                'label' => $this->module->l('Merchant Center Prefix'),
                'name' => self::FORM_ID.'_retail_prefix',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('Add a prefix to match with product ID from the data feed'),
                'hint' => $this->module->l('Use {lang} or {country} vars for language or country iso values') .
                    ', ' .
                    $this->module->l('{LANG} or {COUNTRY} for uppercase mode')
            ],
            [
                'type' => 'text',
                'label' => $this->module->l('Merchant Center Variant'),
                'name' => self::FORM_ID.'_retail_variant',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('Add key for variant ID / Leaves empty for disable'),
                'hint' => $this->module->l('Ex. Use "v" for split the product ID(55) and variant ID(7) - Result: 55v7')
            ],
            [
                'type' => 'switch',
                'label' => $this->module->l('Dynamic Remarketing (Custom)'),
                'name' => self::FORM_ID.'_is_remarketing_custom',
                'desc' => $this->module->l('Remarketing with Business Data feed'),
                'values' => [
                    [
                        'id' => 'active_on',
                        'value' => true
                    ],
                    [
                        'id' => 'active_off',
                        'value' => false
                    ]
                ]
            ],
            [
                'type' => 'text',
                'label' => $this->module->l('Business Data Prefix'),
                'name' => self::FORM_ID.'_custom_prefix',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('Add a prefix to match with product ID from the data feed'),
                'hint' => $this->module->l('Use {lang} or {country} vars for language or country iso values') .
                    ', ' .
                    $this->module->l('{LANG} or {COUNTRY} for uppercase mode')
            ],
            [
                'type' => 'text',
                'label' => $this->module->l('Business Data Variant'),
                'name' => self::FORM_ID.'_custom_variant',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('Add key for variant ID / Leaves empty for disable'),
                'hint' => $this->module->l('Ex. Use "v" for split the product ID(55) and variant ID(7) - Result: 55v7')
            ],
            [
                'type' => 'switch',
                'label' => $this->module->l('Data Feed ID2'),
                'name' => self::FORM_ID.'_is_custom_id2',
                'desc' => $this->module->l('Enable when data feed has ID2 field for variants'),
                'hint' => $this->module->l('if enabled') .
                    ', ' .
                    $this->module->l('Business Data Variant will be used as prefix for ID2')
                ,
                'values' => [
                    [
                        'id' => 'active_on',
                        'value' => true
                    ],
                    [
                        'id' => 'active_off',
                        'value' => false
                    ]
                ]
            ],
        ];
    }
}
