<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form\Section;

use ReactionCode\RCPGTagManager\PSModule\Form\Validator\PregMatchValidator;

class FormGAds extends AbstractFormSection
{
    const FORM_ID = 'gads';
    const PROPERTY_PATTER = '/^[0-9]{4,14}$/i';
    const CONVERSION_PATTERN = '/^[\w\-]{15,24}$/i';

    /**
     * @return string[]
     */
    public function getTab(): array
    {
        return [
            'id' => self::FORM_ID,
            'group' => 'form',
            'name' => 'Google Ads'
        ];
    }

    /**
     * @return array
     */
    public function getInputs(): array
    {
        return [
            [
                'type' => 'text',
                'label' => 'Google Ads ID',
                'name' => self::FORM_ID.'_tracking_id',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('The format is') . ': 123456789',
                'validate' => new PregMatchValidator(self::PROPERTY_PATTER)
            ],
            [
                'type' => 'text',
                'label' => 'Google Merchant ID',
                'name' => self::FORM_ID.'_merchant_id',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('The format is') . ': 123456789',
                'hint' => $this->module->l('Required for send Cart Data on purchase'),
                'validate' => new PregMatchValidator(self::PROPERTY_PATTER)
            ],
            /** todo: -- Coming soon feature --
             * [
             * 'type' => 'text',
             * 'label' => $this->module->l('Conversion Label for') .
             * ' ' .
             * $this->module->l('Contact Phone')
             * ,
             * 'name' => self::FORM_ID.'_phone_conversion',
             * 'class' => 'fixed-width-xl',
             * 'desc' => $this->module->l('Conversion label for phone contact event'),
             * 'validate' => new PregMatchValidator(self::CONVERSION_PATTERN)
             * ],
             * [
             * 'type' => 'text',
             * 'label' => $this->module->l('Conversion Label for') .
             * ' ' .
             * $this->module->l('Newsletter')
             * ,
             * 'name' => self::FORM_ID.'_newsletter_conversion',
             * 'class' => 'fixed-width-xl',
             * 'desc' => $this->module->l('Conversion label for sign up on newsletter'),
             * 'validate' => new PregMatchValidator(self::CONVERSION_PATTERN)
             * ],
             **/
            [
                'type' => 'text',
                'label' => $this->module->l('Conversion Label for') .
                    ' ' .
                    $this->module->l('Create Account')
                ,
                'name' => self::FORM_ID.'_create_account_conversion',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('Conversion label for create a new account'),
                'validate' => new PregMatchValidator(self::CONVERSION_PATTERN)
            ],
            [
                'type' => 'text',
                'label' => $this->module->l('Conversion Label for') .
                    ' ' .
                    $this->module->l('Product View')
                ,
                'name' => self::FORM_ID.'_product_view_conversion',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('Conversion label for view a key page'),
                'validate' => new PregMatchValidator(self::CONVERSION_PATTERN)
            ],
            [
                'type' => 'text',
                'label' => $this->module->l('Conversion Label for') .
                    ' ' .
                    $this->module->l('Add to Cart')
                ,
                'name' => self::FORM_ID.'_add_cart_conversion',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('Conversion label for add to cart'),
                'validate' => new PregMatchValidator(self::CONVERSION_PATTERN)
            ],
            [
                'type' => 'text',
                'label' => $this->module->l('Conversion Label for') .
                    ' ' .
                    $this->module->l('Begin Checkout')
                ,
                'name' => self::FORM_ID.'_begin_checkout_conversion',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('Conversion label for begin checkout'),
                'validate' => new PregMatchValidator(self::CONVERSION_PATTERN)
            ],
            [
                'type' => 'text',
                'label' => $this->module->l('Conversion Label for') .
                    ' ' .
                    $this->module->l('Purchase')
                ,
                'name' => self::FORM_ID.'_purchase_conversion',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('Conversion label for purchase'),
                'validate' => new PregMatchValidator(self::CONVERSION_PATTERN)
            ]
        ];
    }
}
