<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form\Section;

use ReactionCode\RCPGTagManager\PSModule\Form\Validator\PregMatchValidator;

class FormGA4 extends AbstractFormSection
{
    const FORM_ID = 'ga4';

    /**
     * @return string[]
     */
    public function getTab(): array
    {
        return [
            'id' => self::FORM_ID,
            'group' => 'form',
            'name' => 'Google Analytics 4'
        ];
    }

    /**
     * @return array[]
     */
    public function getInputs(): array
    {
        return [
            [
                'type' => 'text',
                'label' => 'Google Analytics 4 ID',
                'name' => self::FORM_ID.'_tracking_id',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('The format is') . ': G-XXXXXXX',
                'validate' => new PregMatchValidator('/^G-[A-Z0-9]{4,14}?$/i')
            ],
            [
                'type' => 'switch',
                'label' => $this->module->l('Data Import'),
                'name' => self::FORM_ID.'_is_data_import',
                'desc' => $this->module->l('Enable Data Import for products'),
                'hint' => $this->module->l('Check the guide for detailed instructions'),
                'values' => [
                    [
                        'id' => 'active_on',
                        'value' => true
                    ],
                    [
                        'id' => 'active_off',
                        'value' => false
                    ]
                ]
            ]
        ];
    }
}
