<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form\Section;

use Context;
use Exception;
use ReactionCode\RCPGTagManager\PSModule\RCTrackingModuleInterface;

class FormCron extends AbstractFormSection
{
    const FORM_ID = 'cron';

    private $input_token_name = self::FORM_ID.'_token';

    private $token;

    public function __construct(RCTrackingModuleInterface $module)
    {
        parent::__construct($module);
        $this->token = $this->getTokenValue();
    }

    /**
     * @return string
     */
    private function getTokenValue(): string
    {
        $values = $this->getFormValues();
        return $values[$this->input_token_name];
    }

    /**
     * @return array
     */
    public function getTab(): array
    {
        return [
            'id' => self::FORM_ID,
            'group' => 'form',
            'name' => $this->module->l('Recover Transactions')
        ];
    }

    /**
     * @inheritDoc
     * @throws Exception
     */
    public function getInputs(): array
    {
        $token = $this->module->getServiceProvider()->getTokenService();
        return [
            [
                'type' => 'html',
                'col' => 11,
                'col_offset' => 1,
                'name' => $this->input_token_name,
                'html_content' => implode($this->getDesc()),
                'default_value' => $token->createPrivateToken(16)
            ],
        ];
    }

    /**
     * @return string[]
     */
    private function getDesc(): array
    {
        return [
            '<h3>'.$this->module->l('Cron job URL to recover transactions').'</h3>',
            '<p>'.$this->module->l(
                'Configure a cron job to recover transactions not handled by the module'
            ).'</p>',
            '<p>'.$this->module->l(
                'Check the guide to know on which cases the module cannot send a transaction'
            ).'</p>',
            '<p>'.$this->module->l(
                'The recovery job will only take into account missing orders from last 24h'
            ).'</p>',
            '<p><b>'.$this->module->l(
                'The recommended configuration is every day each 10 minutes'
            ).'</b></p>',
            '<div class="well"><kbd>'.$this->getCronURL().'</kbd></div>'
        ];
    }

    /**
     * @return string
     */
    private function getCronURL(): string
    {
        $params = [
            'fc' => 'module',
            'module' => $this->module->name,
            'controller' => 'crontask',
            'token' => $this->token
        ];
        return Context::getContext()->shop->getBaseURL(true) . 'index.php?' . http_build_query($params);
    }
}
