<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form\Section;

use Context;
use OrderState;

class FormCheckout extends AbstractFormSection
{
    const FORM_ID = 'checkout';

    /**
     * @return array
     */
    public function getTab(): array
    {
        return [
            'id' => self::FORM_ID,
            'group' => 'form',
            'name' => $this->module->l('Checkout Configuration')
        ];
    }

    /**
     * @return array[]
     */
    public function getInputs(): array
    {
        return [
            [
                'type' => 'checkbox',
                'multiple' => true,
                'label' => $this->module->l('Invalid Order Statuses'),
                'name' => self::FORM_ID.'_invalid_order_status',
                'hint' => $this->module->l(
                    'Select which statuses are related to invalid payments'
                ),
                'desc' => $this->module->l(
                    'Warning! bad selection could has negative impact on transactions'
                ),
                'is_array_model' => true,
                'expand' => [
                    'default' => 'show',
                    'show' => [
                        'icon' => 'gear',
                        'text' => $this->module->l('Show Options'),
                    ],
                    'hide' => [
                        'icon' => 'gear',
                        'text' => $this->module->l('Hide Options'),
                    ]
                ],
                'values' => [
                    'query' => $this->getOrderStates(),
                    'id' => 'id_order_state',
                    'name' => 'name'
                ],
                'default_value' => ['0','6','7','8']
            ],
            [
                'type' => 'checkbox',
                'multiple' => true,
                'label' => $this->module->l('Refund statuses'),
                'name' => self::FORM_ID.'_refund_order_status',
                'hint' => $this->module->l(
                    'Select which statuses are related to refunds or cancellations'
                ),
                'desc' => $this->module->l(
                    'Warning! bad selection could has negative impact on transactions'
                ),
                'is_array_model' => true,
                'expand' => [
                    'default' => 'show',
                    'show' => [
                        'icon' => 'gear',
                        'text' => $this->module->l('Show Options'),
                    ],
                    'hide' => [
                        'icon' => 'gear',
                        'text' => $this->module->l('Hide Options'),
                    ]
                ],
                'values' => [
                    'query' => $this->getOrderStates(),
                    'id' => 'id_order_state',
                    'name' => 'name'
                ],
                'default_value' => ['0','6','7']
            ]
        ];
    }

    /**
     * @return array
     */
    private function getOrderStates(): array
    {
        $hidden_status = [
            'id_order_state' => '0',
            'name' => 'is_empty_selection',
            'is_hidden' => true

        ];
        $order_states = OrderState::getOrderStates(Context::getContext()->language->id);

        array_unshift($order_states, $hidden_status);

        return $order_states;
    }
}
