<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form\Section;

use ReactionCode\RCPGTagManager\PSModule\Form\Validator\PregMatchValidator;

class FormBing extends AbstractFormSection
{
    const FORM_ID = 'bing';

    /**
     * @return string[]
     */
    public function getTab(): array
    {
        return [
            'id' => self::FORM_ID,
            'group' => 'form',
            'name' => 'Bing'
        ];
    }

    /**
     * @return array[]
     */
    public function getInputs(): array
    {
        return [
            [
                'type' => 'text',
                'label' => 'Bing UET Tag',
                'name' => self::FORM_ID.'_tracking_id',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('The format is') . ': 123456789',
                'validate' => new PregMatchValidator('/^[0-9]{4,10}$/i')
            ],
            [
                'type' => 'text',
                'label' => $this->module->l('Catalog Prefix'),
                'name' => self::FORM_ID.'_feed_prefix',
                'class' => 'fixed-width-xl',
                'desc' => sprintf(
                    $this->module->l(
                        'Add a prefix to match product ID with the ID of your %s Catalog'
                    ),
                    $this->getTab()['name']
                ),
                'hint' => $this->module->l(
                    'Use {lang} or {country} vars for language or country iso values'
                ) . ', ' . $this->module->l('{LANG} or {COUNTRY} for uppercase mode')
            ],
            [
                'type' => 'text',
                'label' => $this->module->l('Catalog Variant'),
                'name' => self::FORM_ID.'_feed_variant',
                'class' => 'fixed-width-xl',
                'desc' => $this->module->l('Add key for variant ID / Leaves empty for disable'),
                'hint' => $this->module->l(
                    'Ex. Use "v" for split the product ID(55) and variant ID(7) - Result: 55v7'
                )
            ]
        ];
    }
}
