<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form\Section;

use ReactionCode\RCPGTagManager\PSModule\Form\Transformer\DomainListToStringTransformer;
use ReactionCode\RCPGTagManager\PSModule\Form\Validator\PregMatchValidator;

class FormAPICommon extends AbstractFormSection
{
    const FORM_ID = 'api_common';

    /**
     * @return array
     */
    public function getTab(): array
    {
        return [
            'id' => self::FORM_ID,
            'group' => 'form',
            'name' => $this->module->l('API Common')
        ];
    }

    /**
     * @return array[]
     */
    public function getInputs(): array
    {
        return [
            [
                'type' => 'select',
                'label' => $this->module->l('Campaign Timeout (Months)'),
                'name' => self::FORM_ID.'_campaign_timeout',
                'desc' => $this->module->l('Maximum time to look in connections for a valid referral'),
                'options' => [
                    'query' => $this->getCampaignTimeout(),
                    'id' => 'id',
                    'name' => 'name'
                ],
                'default_value' => 1
            ],
            [
                'type' => 'textarea',
                'label' => $this->module->l('Referral Exclusion List'),
                'name' => self::FORM_ID.'_referral_exclusion_list',
                'class' => 'fixed-width-xl js-textarea-list',
                'desc' => $this->module->l('Exclude domains from source connection detection'),
                'hint' => $this->module->l('Include one domain by line'),
                'is_array_model' => true,
                'transform' => new DomainListToStringTransformer(),
                'validate' => new PregMatchValidator(
                    '/^(?=.{3,256}$)((?:(?!-)[a-z0-9-]{2,63}(?<!-)\.){1,127}(?:(?!\.)[a-z]{2,6}(?<!\.)))$/'
                )
            ]
        ];
    }

    /**
     * @return array
     */
    private function getCampaignTimeout(): array
    {
        $campaign_timeout = [];
        foreach (range(1, 24) as $index) {
            $campaign_timeout[] = [
                'id' => $index,
                'name' => $index
            ];
        }
        return $campaign_timeout;
    }
}
