<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form;

use ReactionCode\RCPGTagManager\PSModule\RCTrackingModuleInterface;

class FormHandler
{
    /**
     * @var FormBuilder
     */
    private $form_builder;

    /**
     * @var FormComponentFactory
     */
    private $form_factory;

    public function __construct(RCTrackingModuleInterface $module)
    {
        $this->form_builder = new FormBuilder();
        $this->form_factory = new FormComponentFactory($module);

        $this->buildForm();
    }

    /**
     * @return array
     */
    public function getTabs(): array
    {
        return $this->form_builder->getTabs();
    }

    /**
     * @return array
     */
    public function getForm(): array
    {
        return $this->form_builder->getForms();
    }

    /**
     * @return array
     */
    public function getFormValues(): array
    {
        return $this->form_builder->getValues();
    }

    /**
     * @return void
     */
    public function submitRequest()
    {
        if ($this->form_builder->isValidRequest()) {
            $this->form_builder->setFormData();
        }
    }

    /**
     * @return bool
     */
    public function setDefaultValues(): bool
    {
        return $this->form_builder->setDefaultValues();
    }

    /**
     * @return array
     */
    public function getErrors(): array
    {
        return $this->form_builder->getErrors();
    }

    private function buildForm()
    {
        $this->form_builder->registerFormSection($this->form_factory->createFormGTM());
        $this->form_builder->registerFormSection($this->form_factory->createFormGUA());
        $this->form_builder->registerFormSection($this->form_factory->createFormGA4());
        $this->form_builder->registerFormSection($this->form_factory->createFormGAds());
        $this->form_builder->registerFormSection($this->form_factory->createFormGFeeds());
        $this->form_builder->registerFormSection($this->form_factory->createFormOptimize());
        $this->form_builder->registerFormSection($this->form_factory->createFormBing());
        $this->form_builder->registerFormSection($this->form_factory->createFormCriteo());
        $this->form_builder->registerFormSection($this->form_factory->createFormFacebook());
        $this->form_builder->registerFormSection($this->form_factory->createFormTwitter());
        $this->form_builder->registerFormSection($this->form_factory->createFormCheckoutBehavior());
        $this->form_builder->registerFormSection($this->form_factory->createFormAPICommon());
        $this->form_builder->registerFormSection($this->form_factory->createFormCron());
        $this->form_builder->registerFormSection($this->form_factory->createFormGuideLinkTab());
        $this->form_builder->registerFormSection($this->form_factory->createFormSupportLinkTab());
        $this->form_builder->registerFormSection($this->form_factory->createFormRateLinkTab());
    }
}
