<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form;

use Module;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormAPICommon;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormBing;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormCriteo;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormFacebook;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormGA4;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormGAds;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormGFeeds;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormGTM;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormGUA;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormGuideLinkTab;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormCheckout;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormOptimize;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormRateLinkTab;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormSectionInterface;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormSupportLinkTab;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormCron;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormTwitter;
use ReactionCode\RCPGTagManager\PSModule\RCTrackingModuleInterface;

class FormComponentFactory
{
    /**
     * @var Module & RCTrackingModuleInterface
     */
    protected $module;

    public function __construct(RCTrackingModuleInterface $module)
    {
        $this->module = $module;
    }

    /**
     * @return FormSectionInterface
     */
    public function createFormAPICommon()
    {
        return new FormAPICommon($this->module);
    }

    /**
     * @return FormSectionInterface
     */
    public function createFormBing()
    {
        return new FormBing($this->module);
    }

    /**
     * @return FormSectionInterface
     */
    public function createFormCriteo()
    {
        return new FormCriteo($this->module);
    }

    /**
     * @return FormSectionInterface
     */
    public function createFormCron()
    {
        return new FormCron($this->module);
    }

    /**
     * @return FormSectionInterface
     */
    public function createFormFacebook()
    {
        return new FormFacebook($this->module);
    }

    /**
     * @return FormSectionInterface
     */
    public function createFormGA4()
    {
        return new FormGA4($this->module);
    }

    /**
     * @return FormSectionInterface
     */
    public function createFormGAds()
    {
        return new FormGAds($this->module);
    }

    /**
     * @return FormSectionInterface
     */
    public function createFormGFeeds()
    {
        return new FormGFeeds($this->module);
    }

    /**
     * @return FormSectionInterface
     */
    public function createFormGTM()
    {
        return new FormGTM($this->module);
    }

    /**
     * @return FormSectionInterface
     */
    public function createFormGUA()
    {
        return new FormGUA($this->module);
    }

    /**
     * @return FormSectionInterface
     */
    public function createFormGuideLinkTab()
    {
        return new FormGuideLinkTab($this->module);
    }

    /**
     * @return FormSectionInterface
     */
    public function createFormOptimize()
    {
        return new FormOptimize($this->module);
    }

    /**
     * @return FormSectionInterface
     */
    public function createFormCheckoutBehavior()
    {
        return new FormCheckout($this->module);
    }

    /**
     * @return FormSectionInterface
     */
    public function createFormRateLinkTab()
    {
        return new FormRateLinkTab($this->module);
    }

    /**
     * @return FormSectionInterface
     */
    public function createFormSupportLinkTab()
    {
        return new FormSupportLinkTab($this->module);
    }

    /**
     * @return FormSectionInterface
     */
    public function createFormTwitter()
    {
        return new FormTwitter($this->module);
    }
}
