<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Form;

use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormSectionInterface;

class FormBuilder
{
    /**
     * @var FormSectionInterface[]
     */
    private $sections = [];

    /**
     * @return array
     */
    public function getTabs(): array
    {
        $tabs = [];
        foreach ($this->sections as $section) {
            $tab = $section->getTab();
            if (!empty($tab)) {
                $tabs[$tab['group']][$tab['id']] = $tab;
            }
        }
        return $tabs;
    }

    /**
     * @return array
     */
    public function getForms(): array
    {
        $forms = [];
        foreach ($this->sections as $section) {
            $form = $section->getForm();
            if (!empty($form)) {
                $forms[$form['tab_id']] = $form;
            }
        }
        return $forms;
    }

    /**
     * @return array
     */
    public function getInputs(): array
    {
        $inputs = [];
        foreach ($this->sections as $section) {
            $section_inputs = $section->getInputs();
            if (!empty($section_inputs)) {
                $inputs = array_merge($section_inputs, $inputs);
            }
        }
        return $inputs;
    }

    /**
     * @return array
     */
    public function getValues(): array
    {
        $values = [];
        foreach ($this->sections as $section) {
            $section_values = $section->getFormValues();
            if (!empty($section_values)) {
                $values = array_merge($section_values, $values);
            }
        }
        return $values;
    }

    /**
     * @return bool
     */
    public function isValidRequest(): bool
    {
        $is_valid = true;
        foreach ($this->sections as $section) {
            $is_valid &= $section->isValid();
        }
        return $is_valid;
    }

    public function setFormData()
    {
        foreach ($this->sections as $section) {
            $section->setValues();
        }
    }

    /**
     * @return bool
     */
    public function setDefaultValues(): bool
    {
        $result = true;
        foreach ($this->sections as $section) {
            $result = $result && $section->setDefaultValues();
        }
        return $result;
    }

    /**
     * @return array
     */
    public function getErrors(): array
    {
        $errors = [];
        foreach ($this->sections as $section) {
            $errors = array_merge($errors, $section->getErrors());
        }
        return $errors;
    }

    /**
     * @param FormSectionInterface $section
     */
    public function registerFormSection(FormSectionInterface $section)
    {
        $this->sections[] = $section;
    }
}
