<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\User;

class UserModelBuilderPS17 extends AbstractUserModelBuilder
{
    /**
     * @inheritDoc
     */
    protected function setAddressModel()
    {
        $address = $this->getSelectedAddress();

        if (is_array($address) && !empty($address)) {
            $address_model = $this->model->getAddressModel();
            $address_model->setAddress1((string)$address['address1']);
            $address_model->setAddress2((string)$address['address2']);
            $address_model->setCompany((string)$address['company']);
            $address_model->setPhone((string)$address['phone']);
            $address_model->setPostCode((string)$address['postcode']);
            $address_model->setCity((string)$address['city']);
            $address_model->setState((string)$address['state']);
            $address_model->setStateCode((string)$address['state_iso']);
            $address_model->setCountry((string)$address['country']);
            $address_model->setCountryCode((string)$address['country_iso']);
        }
    }

    /**
     * @return string[]
     */
    private function getSelectedAddress(): array
    {
        $id_address = $this->getIdAddress();
        return $this->customer->getSimpleAddress($id_address);
    }
}
