<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\User;

class UserModelBuilderPS16 extends AbstractUserModelBuilder
{
    /**
     * @inheritDoc
     */
    protected function setAddressModel()
    {
        $address = $this->getSelectedAddress();

        $address_model = $this->model->getAddressModel();
        $address_model->setAddress1((string)$address['address1']);
        $address_model->setAddress2((string)$address['address2']);
        $address_model->setCompany((string)$address['company']);
        $address_model->setPhone($this->getPhone($address));
        $address_model->setPostCode((string)$address['postcode']);
        $address_model->setCity((string)$address['city']);
        $address_model->setState((string)$address['state']);
        $address_model->setStateCode((string)$address['state_iso']);
        $address_model->setCountry((string)$address['country']);
        $address_model->setCountryCode((string)$address['country_iso']);
    }

    /**
     * @return string[]
     */
    private function getSelectedAddress(): array
    {
        $default_address = [
            'address1' => '',
            'address2' => '',
            'company' => '',
            'phone' => '',
            'postcode' => '',
            'city' => '',
            'state' => '',
            'state_iso' => '',
            'country' => '',
            'country_iso' => '',
        ];

        $selected_address = [];

        $id_address = $this->getIdAddress();
        if ($id_address) {
            $all_addresses = $this->customer->getAddresses($this->context->language->id);
            if (!empty($all_addresses)) {
                $id_addresses = array_column($all_addresses, 'id_address');
                $index_address = array_search((string)$id_address, $id_addresses, true);
                $selected_address = $all_addresses[$index_address];
            }
        }
        return array_merge($default_address, $selected_address);
    }

    /**
     * @param array $address
     * @return string
     */
    private function getPhone(array $address): string
    {
        return (string)(
            !empty($address['phone_mobile']) ?
                $address['phone_mobile'] :
                $address['phone']
        );
    }
}
