<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\User;

use Customer;
use Order;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\AbstractModelBuilderInterface;

interface UserModelBuilderInterface extends AbstractModelBuilderInterface
{
    /**
     * @param Customer $customer
     * @param Order|null $order
     * @return void
     */
    public function initModel(Customer $customer, Order $order = null);

    /**
     * @return void
     */
    public function setIsNewAccount();

    /**
     * @return void
     */
    public function setIsNewLogin();
}
