<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\Search;

use ReactionCode\RCPGTagManager\DataModel\Search\SearchModel;
use Tools;

abstract class AbstractSearchModelBuilder implements SearchModelBuilderInterface
{
    /**
     * @var array
     */
    protected $search_keys;

    /**
     * @var SearchModel
     */
    public $model;

    /**
     * @return void
     */
    public function initModel()
    {
        $this->model = new SearchModel();
        $this->model->setSearchTerm($this->getSearchTerm());
    }

    /**
     * @return string
     */
    public function getSearchTerm(): string
    {
        $search_term = '';
        foreach ($this->search_keys as $search_key) {
            $search_term = Tools::getValue($search_key, '');
            if (!empty($search_term)) {
                break;
            }
        }
        return $search_term;
    }

    /**
     * @return SearchModel
     */
    public function getModel(): SearchModel
    {
        return $this->model;
    }
}
