<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\Product;

use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\AbstractModelBuilderInterface;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\Category\CategoryModelBuilderInterface;

interface ProductModelBuilderInterface extends AbstractModelBuilderInterface
{
    /**
     * @param int $id_product
     * @param int $id_product_attribute
     * @param int $id_lang
     * @return void
     */
    public function initModel(int $id_product, int $id_product_attribute = 0, int $id_lang = 0);

    /**
     * @param CategoryModelBuilderInterface $category_builder
     */
    public function setDetailData(CategoryModelBuilderInterface $category_builder);

    /**
     * @param float $price
     * @param float $price_tax_excl
     * @param int $quantity
     */
    public function setOderData(float $price, float $price_tax_excl, int $quantity);
}
