<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder;

use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\Category\CategoryModelBuilderInterface;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\Category\CategoryModelBuilderPS16;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\Order\OrderModelBuilderInterface;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\Order\OrderModelBuilderPS16;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\Product\ProductModelBuilderInterface;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\Product\ProductModelBuilderPS16;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\Search\SearchModelBuilderInterface;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\Search\SearchModelBuilderPS16;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\User\UserModelBuilderInterface;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\User\UserModelBuilderPS16;

class ModelBuilderFactoryPS16 implements ModelBuilderFactoryInterface
{
    /**
     * @return CategoryModelBuilderInterface
     */
    public function createCategoryModelBuilder(): CategoryModelBuilderInterface
    {
        return new CategoryModelBuilderPS16();
    }

    /**
     * @return ProductModelBuilderInterface
     */
    public function createProductModelBuilder(): ProductModelBuilderInterface
    {
        return new ProductModelBuilderPS16();
    }

    /**
     * @return OrderModelBuilderInterface
     */
    public function createOrderModelBuilder(): OrderModelBuilderInterface
    {
        return new OrderModelBuilderPS16();
    }

    /**
     * @return UserModelBuilderInterface
     */
    public function createUserModelBuilder(): UserModelBuilderInterface
    {
        return new UserModelBuilderPS16();
    }

    /**
     * @return SearchModelBuilderInterface
     */
    public function createSearchModelBuilder(): SearchModelBuilderInterface
    {
        return new SearchModelBuilderPS16();
    }
}
