<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder;

use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\Product\ProductModelBuilderInterface;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\User\UserModelBuilderInterface;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\Order\OrderModelBuilderInterface;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\Search\SearchModelBuilderInterface;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\Category\CategoryModelBuilderInterface;

interface ModelBuilderFactoryInterface
{
    /**
     * @return CategoryModelBuilderInterface
     */
    public function createCategoryModelBuilder(): CategoryModelBuilderInterface;

    /**
     * @return UserModelBuilderInterface
     */
    public function createUserModelBuilder(): UserModelBuilderInterface;

    /**
     * @return OrderModelBuilderInterface
     */
    public function createOrderModelBuilder(): OrderModelBuilderInterface;

    /**
     * @return ProductModelBuilderInterface
     */
    public function createProductModelBuilder(): ProductModelBuilderInterface;

    /**
     * @return SearchModelBuilderInterface
     */
    public function createSearchModelBuilder(): SearchModelBuilderInterface;
}
