<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\Category;

use Cache;

class CategoryModelBuilderPS17 extends AbstractCategoryModelBuilder
{
    /**
     * @param int $id_lang
     * @return string[]
     */
    protected function getCategoryPath(int $id_lang): array
    {
        $category_path = [];
        $cache_key = __METHOD__ . $this->model->getIdCategory() . '_' . $id_lang;

        if (!Cache::isStored($cache_key)) {
            $parents_categories = $this->category->getParentsCategories($id_lang);
            if (!empty($parents_categories)) {
                $category_path = array_reverse(array_column($parents_categories, 'name'));
            }
            Cache::store($cache_key, json_encode($category_path));
        } else {
            $category_path = json_decode(Cache::retrieve($cache_key));
        }
        return $category_path;
    }
}
