<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\Category;

use Category;
use ReactionCode\RCPGTagManager\DataModel\Category\CategoryModel;

abstract class AbstractCategoryModelBuilder implements CategoryModelBuilderInterface
{
    /**
     * @var Category
     */
    protected $category;

    /**
     * @var CategoryModel
     */
    protected $model;

    public function initModel(int $id_category, int $id_lang)
    {
        $this->category = new Category($id_category, $id_lang);
        $this->model = new CategoryModel();
        $this->model->setIdCategory($id_category);
        $this->model->setPath($this->getCategoryPath($id_lang));
    }

    /**
     * @param int $id_lang
     * @return array
     */
    abstract protected function getCategoryPath(int $id_lang): array;

    /**
     * @return CategoryModel
     */
    public function getModel(): CategoryModel
    {
        return $this->model;
    }
}
