<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\DataModelHandler;

use Order;
use ReactionCode\RCPGTagManager\DataModel\Category\CategoryModel;
use ReactionCode\RCPGTagManager\DataModel\Order\OrderModel;
use ReactionCode\RCPGTagManager\DataModel\Product\ProductModelListInterface;
use ReactionCode\RCPGTagManager\DataModel\Search\SearchModel;
use ReactionCode\RCPGTagManager\DataModel\User\UserModel;

interface DataModelHandlerInterface
{
    /**
     * @param int $id_category
     * @param int $id_lang
     * @return CategoryModel
     */
    public function buildCategoryModel(int $id_category, int $id_lang): CategoryModel;

    /**
     * @return SearchModel
     */
    public function buildSearchModel(): SearchModel;

    /**
     * @param array $products
     * @param int $id_lang
     * @return ProductModelListInterface
     */
    public function buildDetailProductModelList(array $products, int $id_lang = 0): ProductModelListInterface;

    /**
     * @param array $products
     * @param int $id_lang
     * @return ProductModelListInterface
     */
    public function buildOrderProductModelList(array $products, int $id_lang = 0): ProductModelListInterface;

    /**
     * @param array $products
     * @param int $id_lang
     * @return ProductModelListInterface
     */
    public function buildAPIProductModelList(array $products, int $id_lang = 0): ProductModelListInterface;

    /**
     * @param Order $order
     * @return OrderModel
     */
    public function buildOrderModel(Order $order): OrderModel;

    /**
     * @param Order|null $order
     * @return UserModel
     */
    public function buildUserModel(Order $order = null): UserModel;
}
