<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Content;

use Configuration;
use Exception;
use HelperForm;
use Tools;

class ContentPS17 extends AbstractContent
{
    /**
     * @return string
     */
    protected function renderFormModal(): string
    {
        return $this->module->display(
            $this->module->name,
            'views/templates/admin/_configure/modals.tpl'
        );
    }

    /**
     * @return string
     * @throws Exception
     */
    protected function renderForm(): string
    {
        $helper = new HelperForm();

        // Module, token and currentIndex
        $helper->module = $this->module;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false) .
            '&configure=' . $this->module->name .
            '&tab_module=' . $this->module->tab .
            '&module_name=' . $this->module->name
        ;

        // Language
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        // Title and toolbar
        $helper->title = $this->module->displayName;
        $helper->show_toolbar = true;

        $helper->submit_action = 'submit'.$this->module->name;

        $helper->tpl_vars = [
            'vertical_tabs' => $this->form_service->getTabs(),
            'fields_value' => $this->form_service->getFormValues()
        ];

        // allow multiple forms to combine with tabs
        $helper->multiple_fieldsets = true;

        return $helper->generateForm($this->form_service->getForm());
    }

    /**
     * @return void
     */
    protected function addAssets()
    {
        $this->context->controller->addCSS($this->module->getPathUri().'views/css/admin/common_form.css');
        $this->context->controller->addJS($this->module->getPathUri().'views/js/admin/common_form.js');
        $this->context->controller->addJS($this->module->getPathUri().'views/js/admin/configure/form.js');
    }
}
