<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Content;

use Context;
use Module;
use ReactionCode\RCPGTagManager\PSModule\Form\FormHandler;
use ReactionCode\RCPGTagManager\PSModule\RCTrackingModuleInterface;
use Tools;

abstract class AbstractContent implements ContentInterface
{
    /**
     * @var Module & RCTrackingModuleInterface
     */
    protected $module;

    /**
     * @var Context
     */
    protected $context;

    /**
     * @var FormHandler
     */
    protected $form_service;

    public function __construct(RCTrackingModuleInterface $module)
    {
        $this->module = $module;
        $this->context = Context::getContext();
        $this->form_service = new FormHandler($this->module);
    }

    /**
     * @return string
     */
    public function getContent(): string
    {
        $message = '';
        $modal = $this->renderFormModal();
        $form = $this->renderForm();

        if ($this->isFormSubmit()) {
            $this->form_service->submitRequest();
            $message = $this->getMessage();
        }

        $this->addAssets();

        return $message.$modal.$form;
    }

    /**
     * @return bool
     */
    protected function isFormSubmit(): bool
    {
        return Tools::isSubmit('submit'.$this->module->name) &&
            Tools::getValue('configure') === $this->module->name
        ;
    }

    /**
     * @return string
     */
    protected function getMessage(): string
    {
        $display_errors = array_merge($this->module->getErrors(), $this->form_service->getErrors());

        return empty($display_errors) ?
            $this->module->displayConfirmation(
                $this->module->l('Settings updated successfully')
            ) :
            $this->module->displayError($display_errors)
            ;
    }

    /**
     * @return void
     */
    abstract protected function addAssets();

    /**
     * @return string
     */
    abstract protected function renderFormModal(): string;

    /**
     * @return string
     */
    abstract protected function renderForm(): string;
}
