<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Configurator;

use Module;
use ReactionCode\RCPGTagManager\PSModule\Configurator\Components\AbstractConfigurator;
use ReactionCode\RCPGTagManager\PSModule\Configurator\Components\BingConfigurator;
use ReactionCode\RCPGTagManager\PSModule\Configurator\Components\CheckoutConfigurator;
use ReactionCode\RCPGTagManager\PSModule\Configurator\Components\CriteoConfigurator;
use ReactionCode\RCPGTagManager\PSModule\Configurator\Components\CronConfigurator;
use ReactionCode\RCPGTagManager\PSModule\Configurator\Components\FacebookConfigurator;
use ReactionCode\RCPGTagManager\PSModule\Configurator\Components\APICommonConfigurator;
use ReactionCode\RCPGTagManager\PSModule\Configurator\Components\GA4Configurator;
use ReactionCode\RCPGTagManager\PSModule\Configurator\Components\GAdsConfigurator;
use ReactionCode\RCPGTagManager\PSModule\Configurator\Components\GFeedsConfigurator;
use ReactionCode\RCPGTagManager\PSModule\Configurator\Components\GTMConfigurator;
use ReactionCode\RCPGTagManager\PSModule\Configurator\Components\GUAConfigurator;
use ReactionCode\RCPGTagManager\PSModule\Configurator\Components\OptimizeConfigurator;
use ReactionCode\RCPGTagManager\PSModule\Configurator\Components\ContextConfigurator;
use ReactionCode\RCPGTagManager\PSModule\Configurator\Components\TwitterConfigurator;
use ReactionCode\RCPGTagManager\PSModule\RCTrackingModuleInterface;

class ConfiguratorFactory implements ConfiguratorFactoryInterface
{
    /**
     * @var AbstractConfigurator[]
     */
    private $configurators = [];

    /**
     * @var Module & RCTrackingModuleInterface
     */
    protected $module;

    public function __construct(RCTrackingModuleInterface $module)
    {
        $this->module = $module;
    }

    /**
     * @return array
     */
    public function getGTMConfiguration(): array
    {
        if (empty($this->configurators['gtm'])) {
            $this->configurators['gtm'] = new GTMConfigurator($this->module);
        }
        return $this->configurators['gtm']->getConfiguration();
    }

    /**
     * @return array
     */
    public function getGUAConfiguration(): array
    {
        if (empty($this->configurators['gua'])) {
            $this->configurators['gua'] = new GUAConfigurator($this->module);
        }
        return $this->configurators['gua']->getConfiguration();
    }

    /**
     * @return array
     */
    public function getGA4Configuration(): array
    {
        if (empty($this->configurators['ga4'])) {
            $this->configurators['ga4'] = new GA4Configurator($this->module);
        }
        return $this->configurators['ga4']->getConfiguration();
    }
    /**
     * @return array
     */
    public function getGAdsConfiguration(): array
    {
        if (empty($this->configurators['gads'])) {
            $this->configurators['gads'] = new GAdsConfigurator($this->module);
        }
        return $this->configurators['gads']->getConfiguration();
    }
    /**
     * @return array|array[]
     */
    public function getGFeedsConfiguration(): array
    {
        if (empty($this->configurators['gfeeds'])) {
            $this->configurators['gfeeds'] = new GFeedsConfigurator($this->module);
        }
        return $this->configurators['gfeeds']->getConfiguration();
    }

    /**
     * @return array
     */
    public function getOptimizeConfiguration(): array
    {
        if (empty($this->configurators['optimize'])) {
            $this->configurators['optimize'] = new OptimizeConfigurator($this->module);
        }
        return $this->configurators['optimize']->getConfiguration();
    }

    /**
     * @return array
     */
    public function getBingConfiguration(): array
    {
        if (empty($this->configurators['bing'])) {
            $this->configurators['bing'] = new BingConfigurator($this->module);
        }
        return $this->configurators['bing']->getConfiguration();
    }

    /**
     * @return array
     */
    public function getCriteoConfiguration(): array
    {
        if (empty($this->configurators['criteo'])) {
            $this->configurators['criteo'] = new CriteoConfigurator($this->module);
        }
        return $this->configurators['criteo']->getConfiguration();
    }

    /**
     * @return array
     */
    public function getFacebookConfiguration(): array
    {
        if (empty($this->configurators['facebook'])) {
            $this->configurators['facebook'] = new FacebookConfigurator($this->module);
        }
        return $this->configurators['facebook']->getConfiguration();
    }

    /**
     * @return array
     */
    public function getTwitterConfiguration(): array
    {
        if (empty($this->configurators['twitter'])) {
            $this->configurators['twitter'] = new TwitterConfigurator($this->module);
        }
        return $this->configurators['twitter']->getConfiguration();
    }

    /**
     * @return array
     */
    public function getCheckoutConfiguration(): array
    {
        if (empty($this->configurators['checkout'])) {
            $this->configurators['checkout'] = new CheckoutConfigurator($this->module);
        }
        return $this->configurators['checkout']->getConfiguration();
    }

    /**
     * @return array
     */
    public function getAPICommonConfiguration(): array
    {
        if (empty($this->configurators['api_common'])) {
            $this->configurators['api_common'] = new APICommonConfigurator($this->module);
        }
        return $this->configurators['api_common']->getConfiguration();
    }

    /**
     * @return array
     */
    public function getCronConfiguration(): array
    {
        if (empty($this->configurators['cron'])) {
            $this->configurators['cron'] = new CronConfigurator($this->module);
        }
        return $this->configurators['cron']->getConfiguration();
    }

    /**
     * @return array
     */
    public function getContextConfiguration(): array
    {
        if (empty($this->configurators['context'])) {
            $this->configurators['context'] = new ContextConfigurator($this->module);
        }
        return $this->configurators['context']->getConfiguration();
    }
}
