<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Configurator\Components;

use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormOptimize;

class OptimizeConfigurator extends AbstractConfigurator
{
    protected function setConfiguration()
    {
        $form_component = $this->getFormComponent();
        $config_values = $form_component->getModelValues($this->id_shop);

        $form_id = $form_component::FORM_ID;

        $this->configuration = [
            'tracking_id' => (string)$config_values[$form_id.'_tracking_id'],
            'is_async' => (bool)$config_values[$form_id.'_is_async'],
            'hiding_class_name' => (string)$config_values[$form_id.'_hiding_class_name'],
            'hiding_timeout' => (int)$config_values[$form_id.'_hiding_timeout']
        ];
    }

    protected function getFormComponent(): FormOptimize
    {
        return new FormOptimize($this->module);
    }
}
