<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Configurator\Components;

use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormGUA;

class GUAConfigurator extends AbstractConfigurator
{
    protected function setConfiguration()
    {
        $form_component = $this->getFormComponent();
        $config_values = $form_component->getModelValues($this->id_shop);

        $form_id = $form_component::FORM_ID;

        $this->configuration = [
            'tracking_id' => (string)$config_values[$form_id.'_tracking_id'],
            'site_speed_sample_rate' => (int)$config_values[$form_id.'_site_speed_sample_rate'],
            'is_data_import' => (bool)$config_values[$form_id.'_is_data_import'],
            'is_anonymize_ip' => (bool)$config_values[$form_id.'_is_anonymize_ip'],
            'is_user_id' => (bool)$config_values[$form_id.'_is_user_id'],
            'is_link_attribution' => (bool)$config_values[$form_id.'_is_link_attribution'],
            'cross_domain_list' => $config_values[$form_id.'_cross_domain_list'],
            'dimensions' => [
                'ecomm_prodid' => (int)$config_values[$form_id.'_dimension_ecomm_prodid'],
                'ecomm_pagetype' => (int)$config_values[$form_id.'_dimension_ecomm_pagetype'],
                'ecomm_totalvalue' => (int)$config_values[$form_id.'_dimension_ecomm_totalvalue'],
                'dynx_itemid' => (int)$config_values[$form_id.'_dimension_dynx_itemid'],
                'dynx_itemid2' => (int)$config_values[$form_id.'_dimension_dynx_itemid2'],
                'dynx_pagetype' => (int)$config_values[$form_id.'_dimension_dynx_pagetype'],
                'dynx_totalvalue' => (int)$config_values[$form_id.'_dimension_dynx_totalvalue']
            ]
        ];
    }

    /**
     * @return FormGUA
     */
    protected function getFormComponent(): FormGUA
    {
        return new FormGUA($this->module);
    }
}
