<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Configurator\Components;

use Cookie;
use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormGTM;

class GTMConfigurator extends AbstractConfigurator
{
    protected function setConfiguration()
    {
        $form_component = $this->getFormComponent();
        $config_values = $form_component->getModelValues($this->id_shop);

        $form_id = $form_component::FORM_ID;

        $this->configuration = [
            'tracking_id' => (string)$config_values[$form_id.'_tracking_id'],
            'is_disable_tracking' => $this->isExcludeInternalTracking(
                $config_values[$form_id.'_is_exclude_internal_tracking']
            ),
        ];
    }

    /**
     * @return FormGTM
     */
    private function getFormComponent(): FormGTM
    {
        return new FormGTM($this->module);
    }

    /**
     * @param $is_exclude_internal_tracking
     * @return bool
     */
    private function isExcludeInternalTracking($is_exclude_internal_tracking): bool
    {
        $tracking_cookie = new Cookie($this->module->name);
        $tracking_cookie->disallowWriting();

        return $is_exclude_internal_tracking && $tracking_cookie->exists();
    }
}
