<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Configurator\Components;

use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormGFeeds;

class GFeedsConfigurator extends AbstractConfigurator
{
    public function setConfiguration()
    {
        $form_component = $this->getFormComponent();
        $config_values = $form_component->getModelValues($this->id_shop);

        $form_id = $form_component::FORM_ID;

        $this->configuration = [
            'retail' => [
                'is_enabled' => (bool)$config_values[$form_id.'_is_remarketing_retail'],
                'prefix' => $this->getFeedPrefixNormalized($config_values[$form_id.'_retail_prefix']),
                'variant' => (string)$config_values[$form_id.'_retail_variant']
            ],
            'custom' => [
                'is_enabled' => (bool)$config_values[$form_id.'_is_remarketing_custom'],
                'is_id2' => (bool)$config_values[$form_id.'_is_custom_id2'],
                'prefix' => $this->getFeedPrefixNormalized($config_values[$form_id.'_custom_prefix']),
                'variant' => (string)$config_values[$form_id.'_custom_variant']
            ]
        ];
    }

    /**
     * @return FormGFeeds
     */
    protected function getFormComponent(): FormGFeeds
    {
        return new FormGFeeds($this->module);
    }
}
